/*tex

Stata/MP 14.1; required packages: estout, estwrite, erepost, coefplot

\subsection{Graphs for prevalence estimates}

tex*/

texdoc stlog
set scheme s1mono
program swapnames // rename nl estimates
    qui est restore `0'
    tempname b
    mat `b' = e(b)
    mata: st_matrixcolstripe("`b'", st_matrixcolstripe("`b'")[., (2,1)])
    erepost b=`b', rename
    qui est store `0'
end
program addbox
    args est w
    qui est restore `est'
    local h = `w'/2         // character halfwidth
    local m = `w'/2 * .25   // outer margin
    mata: st_matrix("e(box)", ///
          (st_matrix("e(b)") :- `m' :- ///
              (strlen(strofreal(st_matrix("e(b)")*100,"%9.0f"))*`h'))  ///
        \ (st_matrix("e(b)") :+ `m' :+ ///
              (strlen(strofreal(st_matrix("e(b)")*100,"%9.0f"))*`h')))
    qui est sto `est'
end
program mlrrt_pr
    tempname b ci V
    qui est restore `0'
    mata: mlrrt_dif("`b'", "`ci'")
    qui est restore `0'_d
    qui estadd matrix ci = `ci'
    mat `V' = `b'' * `b' * 0
    erepost b=`b' V=`V'
    qui est sto `0'_d
    qui est restore `0'
    mata: mlrrt_levels("`b'", "`ci'")
    qui estadd matrix ci = `ci'
    mat `V' = `b'' * `b' * 0
    erepost b=`b' V=`V'
    qui est sto `0'
end
mata
void mlrrt_levels(string scalar b0, string scalar ci) {
    b = st_matrix("e(b)")
    se = sqrt(diagonal(st_matrix("e(V)")))'
    st_matrix(b0, invlogit(b))
    st_matrix(ci, (invlogit(b - invnormal(0.975):*se) \ 
                   invlogit(b + invnormal(0.975):*se)))
    st_matrixcolstripe(b0, st_matrixcolstripe("e(b)"))
}
void mlrrt_dif(string scalar b0, string scalar ci) {
    b = st_matrix("e(b)")
    se = sqrt(diagonal(st_matrix("e(V)")))'
    st_matrix(b0, (invlogit(b[|2 \ .|]):-invlogit(b[1])))
    r = 100000
    st_matrix(ci, mm_quantile((invlogit(rnormal(r,1,b[|2 \ .|],se[|2 \ .|])) :- 
        invlogit(rnormal(r,1,b[1],se[1]))),1,(0.025,0.975)'))
    st_matrixcolstripe(b0, st_matrixcolstripe("e(b)")[|2,1 \ .,2|])
}
end
local q14 "copying from other students in exam"
local q16 "using crib notes in exam"
local q17 "taking drugs to enhance exam performance"
local q18 "including plagiarism in paper"
local q19 "handing in someone else's paper"
forv i = 0/2 {  // 0: all obs 1: good language 2: good language and no pretest
    // graph by implementation
    est clear
    qui estread log/main/detailed`i'
    foreach v in q14 q16 q17 q18 q19 {
        swapnames `v'_nl
        mlrrt_pr `v'_ml
    }
    local ci 95
    foreach e in "" "_nl" "_ml" {
        if "`e'"=="_ml" local ci "ci"
        foreach v in q14 q16 q17 q18 q19 {
            addbox `v'`e'   0.016
            addbox `v'`e'_d 0.009
        }
        coefplot (q14`e', aseq(q14) ///
                \ q16`e', aseq(q16) ///
                \ q17`e', aseq(q17) ///
                \ q18`e', aseq(q18) ///
                \ q19`e', aseq(q19)), bylabel(Prevalence estimate in %) ///
            ||   (q14`e'_d, aseq(q14) ///
                \ q16`e'_d, aseq(q16) ///
                \ q17`e'_d, aseq(q17) ///
                \ q18`e'_d, aseq(q18) ///
                \ q19`e'_d, aseq(q19)), bylabel(Difference to DQ) ///
            ||  , if(!(@ll<1 & @ul>25)) ///
                byopts(xrescale graphregion(margin(l=-5 b=0 t=2 r=2))) ///
                xline(0, lstyle(grid)) rescale(100) xlabel(#7) ///
                mlab msymbol(i) mlabpos(0) format(%9.0f) ///
                ci(`ci' box) ciopts(recast(. rbar) barwidth(. 0.6) color(. white)) ///
                eqlab("`q14'" "`q16'" "`q17'" "`q18'" "`q19'", angle(hor) wrap(13)) ///
                coeflab(FRwheel = "FR Wheel" FRnumb = "FR Number" ///
                        UQbenf = "UQ Benford" CMquest = "CM Question" ///
                        CMnumb = "CM Number", labsize(*0.8)) 
        qui graph export log/grtab/detailed`i'`e'.pdf, replace
    }
}
texdoc stlog close

/*tex

\subsection{Graphs for quality criteria}

tex*/

texdoc stlog
forv i = 0/2 { // 0: all obs 1: good language 2: good language and no pretest
    qui estread log/main/eval`i'
    coefplot  ///
            breakoff,   bylab("Break-off (%)")                       ///
        ||  cumbersome, bylab("Technique is cumbersome (%)")         ///
        ||  nonresp,    bylab("Item nonresponse (%)")                ///
        ||  correct,    bylab("Applied technique correctly (%)")     ///
        ||  time,       bylab("Answering time (seconds)") rescale(1) ///
        ||  tprotect,   bylab("Technique protects (%)")              ///
        ||  trust,      bylab("Trust in anonymity (%)")              ///
        ||  sense,      bylab("Technique is reasonable (%)")         ///
        ||  risk,       bylab("Disclosure risk (%)")                 ///
        ||  understand, bylab("Understood principle (%)")            ///
        ||, byopts(xrescale cols(2) graphregion(margin(l=-5 b=0 t=1 r=1))) ///
        ms(d) rescale(100) ysize(7.4) xlabel(#6) ///
        coeflab(FRwheel = "FR Wheel"  ///
                FRnumb  = "FR Number"  ///
                UQbenf  = "UQ Benford" ///
                CMquest = "CM Question" ///
                CMnumb  = "CM Number")
    qui graph export log/grtab/eval`i'.pdf, replace
}
texdoc stlog close

/*tex

\subsection{Tables for prevalence estimates}

tex*/

texdoc stlog
program eappend
    args m1 eq1 m2 eq2
    tempname b1 V1 b2 V2
    qui est restore `m2'
    mat `b2' = e(b)
    mat `V2' = e(V)
    mat coleq `b2' = `"`eq2'"'
    qui est restore `m1'
    mat `b1' = e(b)
    mat `V1' = e(V)
    mat coleq `b1' = `"`eq1'"'
    mat `b1' = `b1', `b2'
    mat `V1' = (`V1', J(rowsof(`V1'), colsof(`V2'), 0)) \ ///
              (J(rowsof(`V2'), colsof(`V1'), 0), `V2')
    erepost b = `b1' V = `V1', rename
    est sto `m1'
end
local q14 "Copying from other students in exam"
local q16 "Using crib notes in exam"
local q17 "Taking drugs to enhance exam performance"
local q18 "Including plagiarism in paper"
local q19 "Handing in someone else's paper"
forv i = 0/2 { // 0: all obs 1: good language 2: good language and no pretest
    // table by implementation
    est clear
    qui estread log/main/detailed`i'
    foreach v in q14 q16 q17 q18 q19 {
        swapnames `v'_nl
    }
    foreach e in "" "_nl" "_ml" {
        if "`e'"=="_nl"         local eopt "transform(@*100 100) b(2)"
        else if "`e'"=="_ml"    local eopt "b(3)"
        else                    local eopt "transform(@*100 100) b(2)"
        foreach v in q14 q16 q17 q18 q19 {
            eappend `v'`e' "l" `v'`e'_d "d"
        }
        qui esttab q14`e' q16`e' q17`e' q18`e' q19`e' ///
            using log/grtab/detailed`i'`e'.tex ///
            , replace booktabs `eopt' se nostar nonum ///
              mlab("`q14'" "`q16'" "`q17'" "`q18'" "`q19'", ///
                  prefix("\multicolumn{1}{v}{") suffix("}")) nonote ///
              eqlab("\textit{Levels}" "\textit{Differences}") ///
              coeflabels(l:DQ "Direct questioning (DQ)" ///
                         l:FRwheel  "FR Wheel" ///
                         l:FRnumb   "FR Number" ///
                         l:UQbenf   "UQ Benford" ///
                         l:CMquest  "CM Question" ///
                         l:CMnumb   "CM Number" ///
                         d:FRwheel  "FR Wheel -- DQ" ///
                         d:FRnumb   "FR Number -- DQ" ///
                         d:UQbenf   "UQ Benford -- DQ" ///
                         d:CMquest  "CM Question -- DQ" ///
                         d:CMnumb   "CM Number -- DQ")
    }
}
texdoc stlog close

/*tex

\subsection{Tables for quality criteria}

tex*/

texdoc stlog
forv i = 0/2 { // 0: all obs 1: good language 2: good language and no pretest
    qui estread log/main/eval`i'
    qui esttab breakoff nonresp time trust risk ///
        using log/grtab/eval`i'.tex ///
        , replace booktabs eqlab(none) ///
          transform(@*100 100, pattern(1 1 0 1 1)) b(2) se nostar nonum ///
          mlab("Break-off (\%)" ///
               "Item nonresponse (\%)" ///
               "Answering time (seconds)" ///
               "Trust in anonymity (\%)" ///
               "Disclosure risk (\%)", ///
               prefix("\multicolumn{1}{v}{") suffix("}")) nonote ///
          coeflabels(DQ "Direct questioning" ///
                     FRwheel "FR Wheel" ///
                     FRnumb  "FR Number" ///
                     UQbenf  "UQ Benford" ///
                     CMquest  "CM Question" ///
                     CMnumb   "CM Number") ///
          postfoot("\midrule")
    qui esttab cumbersome correct tprotect sense understand ///
        using log/grtab/eval`i'.tex ///
        , append booktabs eqlab(none) ///
          transform(@*100 100) b(2) se nostar nonum ///
          mlab("Technique is cumbersome (\%)" ///
               "Applied technique correctly (\%)" ///
               "Technique protects (\%)" ///
               "Technique is reasonable (\%)" ///
               "Understood principle (\%)", ///
               prefix("\multicolumn{1}{v}{") suffix("}")) nonote ///
          coeflabels(DQ "Direct questioning" ///
                     FRwheel "FR Wheel" ///
                     FRnumb  "FR Number" ///
                     UQbenf  "UQ Benford" ///
                     CMquest  "CM Question" ///
                     CMnumb   "CM Number") ///
          prehead("%")
}
texdoc stlog close


